/*

java --enable-preview -XX:StartFlightRecording=filename=novalhalla.jfr novalhalla.Brownian

For JITWatch:

export LD_LIBRARY_PATH=lib
export GDK_SCALE=2

javac --enable-preview --release 26 novalhalla/Brownian.java
javac --enable-preview --release 26 withvalhalla/Brownian.java
java --enable-preview -XX:+UnlockDiagnosticVMOptions -XX:+PrintAssembly \
-XX:+LogCompilation -XX:LogFile=novalhalla.log novalhalla.Brownian

java --enable-preview -jar jitwatch-ui-1.4.9-shaded-linux-x64.jar

Click Config and make sure code directory is in source and class locations
Click Open Log and select novalhalla.log, then Start

*/

package novalhalla;

record Point(double x, double y) {
    public Point moveBy(double dx, double dy) {
        return new Point(x + dx, y + dy);
    }
}

public class Brownian {
    private static int ITERATIONS = 100_000_000;
   
    public static void main(String[] args) {
        Point p = new Point(0, 0);      
        for (int i = 0; i < ITERATIONS; i++)
            p = p.moveBy(Math.random() - 0.5, Math.random() - 0.5);
        System.out.println(p);
    }
}
