package noflattening;

import jdk.internal.vm.annotation.*;
import jdk.internal.value.*;

value record Point(double x, double y) {
    public Point transform() { return new Point(y + 1, 0.5 - x); }
}

public class Points {
    static int NPOINTS = 100_000_000;
    static int ROUNDS = 10;
    private static final Point[] path
        = (Point[]) ValueClass.newNullRestrictedNonAtomicArray(
            Point.class, NPOINTS, new Point(0, 0));

    public static void main(String[] args) throws InterruptedException {
        for (int r = 0; r < ROUNDS; r++) {
            for (int i = 1; i < path.length; i++) {
                path[i] = path[i - 1].transform();
            }
            System.out.println(path[path.length - 1]);
        }
        Thread.sleep(60_000);
    }
}
