package com.horstmann.novalhalla;

import org.openjdk.jmh.annotations.*;

import static java.util.concurrent.TimeUnit.*;

public class Benchmark2 {
   private static int ITERATIONS = 10_000_000;
   @State(Scope.Benchmark)
   public static class MyState {
      public static double[] randoms = new double[2 * ITERATIONS];
       @Setup(Level.Trial)
       public void doSetup() {
          for (int i = 0; i < randoms.length; i++) randoms[i] = Math.random() - 0.5;
       }
   }
   
   @Benchmark
   @BenchmarkMode(org.openjdk.jmh.annotations.Mode.AverageTime)
   @OutputTimeUnit(MICROSECONDS)
   public Point work(MyState state) {
      Point p = new Point(0, 0);
      int ITERATIONS = 10_000_000;
      for (int i = 0; i < ITERATIONS; i++) {
          p = p.moveBy(state.randoms[2 * i], state.randoms[2 * i + 1]);
      }
      return p;
   }
}

