package com.horstmann;

import java.time.Duration;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import io.smallrye.common.annotation.RunOnVirtualThread;
import io.smallrye.mutiny.Uni;

@Path("/sleep")
public class Sleep {
    @RunOnVirtualThread
    @Path("/virtual")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public String virtual() throws Exception {
        return task();
    }

    @Path("/platform")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public String platform() throws Exception {
        return task();
    }

    private String task() throws InterruptedException {
        Thread.sleep(1_000);
        return Thread.currentThread() + "\r\n";
    }

    @Path("/reactive")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Uni<String> reactive() {
        String result = Thread.currentThread() + "\r\n";
        Uni<String> delayed = Uni.createFrom().item(result)
        .onItem().delayIt().by(Duration.ofMillis(1_000));
        return delayed;
    }

    private static Object lock = new Object();
    
    @RunOnVirtualThread
    @Path("/pin")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public String pin() throws Exception {
        synchronized (lock) {
            return task();
        }
    }    
}
